using System;
using LFS_External;
using LFS_External.InSim;

namespace LFS_External_Client
{
	/// <summary>Holds information of a connected client to the lfs server</summary>
	public class clsConnection
    {
        #region dbCompatibleStats
        protected bool _statsloadedsuccessfully = false;
        /// <summary>
        /// STATS LOAD OK
        /// </summary>
        public bool statsLoadedSuccessfully
        {
            get { return _statsloadedsuccessfully; }
            set { _statsloadedsuccessfully = value; }
        }

        protected int _personalid = 0;
        /// <summary>
        /// id
        /// </summary>
        public int personalId
        {
            get { return _personalid; }
            set { _personalid = value; }
        }

        protected string _accpass = "undefined";
        /// <summary>
        /// acc_pass
        /// </summary>
        public string accPass
        {
            get { return _accpass; }
            set { _accpass = value; }
        }

        protected string _accmasterpass = "undefined";
        /// <summary>
        /// acc_masterpass
        /// </summary>
        public string accMasterPass
        {
            get { return _accmasterpass; }
            set { _accmasterpass = value; }
        }

        protected string _accloggedtill = "0";
        /// <summary>
        /// acc_loggedtill
        /// </summary>
        public string accLoggedTill
        {
            get { return _accloggedtill; }
            set { _accloggedtill = value; }
        }

        protected int _teamid = 0;
        /// <summary>
        /// team_id
        /// </summary>
        public int teamId
        {
            get { return _teamid; }
            set { _teamid = value; }
        }

        protected string _teamname = "_undetected";
        /// <summary>
        /// ----
        /// </summary>
        public string teamName
        {
            get { return _teamname; }
            set { _teamname = value; }
        }

        protected int _teamnumber = 0;
        /// <summary>
        /// team_numb
        /// </summary>
        public int teamNumber
        {
            get { return _teamnumber; }
            set { _teamnumber = value; }
        }

        protected string _teamrank = "_undetected";
        /// <summary>
        /// team_rank
        /// </summary>
        public string teamRank
        {
            get { return _teamrank; }
            set { _teamrank = value; }
        }

        protected bool _teamrankcustom = false;
        /// <summary>
        /// team_rank_custom
        /// </summary>
        public bool teamRankCustom
        {
            get { return _teamrankcustom; }
            set { _teamrankcustom = value; }
        }

        protected string _teamrights = "0";
        /// <summary>
        /// team_rights
        /// </summary>
        public string teamRights
        {
            get { return _teamrights; }
            set { _teamrights = value; }
        }

        protected int _countryid = 0;
        /// <summary>
        /// country_id
        /// </summary>
        public int countryId
        {
            get { return _countryid; }
            set { _countryid = value; }
        }

        protected string _name = "_undetected";
        /// <summary>
        /// name
        /// </summary>
        public string name
        {
            get { return _name; }
            set { _name = value; }
        }

        protected string _gender = "_undetected";
        /// <summary>
        /// gender
        /// </summary>
        public string gender
        {
            get { return _gender; }
            set { _gender = value; }
        }

        protected string _birthdate = "_undetected";
        /// <summary>
        /// birth_date
        /// </summary>
        public string birthDate
        {
            get { return _birthdate; }
            set { _birthdate = value; }
        }

        protected string _email = "_undetected";
        /// <summary>
        /// email
        /// </summary>
        public string email
        {
            get { return _email; }
            set { _email = value; }
        }

        protected bool _emailhide = true;
        /// <summary>
        /// email_hide
        /// </summary>
        public bool emailHide
        {
            get { return _emailhide; }
            set { _emailhide = value; }
        }

        protected string _rank = "_undetected";
        /// <summary>
        /// rank
        /// </summary>
        public string rank
        {
            get { return _rank; }
            set { _rank = value; }
        }

        protected bool _rankcustom = false;
        /// <summary>
        /// rank_custom
        /// </summary>
        public bool rankCustom
        {
            get { return _rankcustom; }
            set { _rankcustom = value; }
        }

        protected string _rights = "0";
        /// <summary>
        /// rights
        /// </summary>
        public string rights
        {
            get { return _rights; }
            set { _rights = value; }
        }

        protected int _maxwinsinarow = 0;
        /// <summary>
        /// max_wins_row
        /// </summary>
        public int maxWinsInARow
        {
            get { return _maxwinsinarow; }
            set { _maxwinsinarow = value; }
        }

        protected int _pointsbronze = 0;
        /// <summary>
        /// points_bronze
        /// </summary>
        public int pointsBronze
        {
            get { return _pointsbronze; }
            set { _pointsbronze = value; }
        }

        protected int _pointssilver = 0;
        /// <summary>
        /// points_silver
        /// </summary>
        public int pointsSilver
        {
            get { return _pointssilver; }
            set { _pointssilver = value; }
        }

        protected int _pointsgold = 0;
        /// <summary>
        /// points_gold
        /// </summary>
        public int pointsGold
        {
            get { return _pointsgold; }
            set { _pointsgold = value; }
        }

        protected int _pointsplatinum = 0;
        /// <summary>
        /// points_platinum
        /// </summary>
        public int pointsPlatinum
        {
            get { return _pointsplatinum; }
            set { _pointsplatinum = value; }
        }

        protected int _pointsglobal = 0;
        /// <summary>
        /// points_global
        /// </summary>
        public int pointsGlobal
        {
            get { return _pointsglobal; }
            set { _pointsglobal = value; }
        }

        protected int _racessum = 0;
        /// <summary>
        /// races_sum
        /// </summary>
        public int racesSum
        {
            get { return _racessum; }
            set { _racessum = value; }
        }

        protected int _raceswon = 0;
        /// <summary>
        /// races_won
        /// </summary>
        public int racesWon
        {
            get { return _raceswon; }
            set { _raceswon = value; }
        }

        protected int _racesSecond = 0;
        /// <summary>
        /// races_2nd
        /// </summary>
        public int racesSecond
        {
            get { return _racesSecond; }
            set { _racesSecond = value; }
        }

        protected int _racesthird = 0;
        /// <summary>
        /// races_3rd
        /// </summary>
        public int racesThird
        {
            get { return _racesthird; }
            set { _racesthird = value; }
        }

        protected int _racesunfinished = 0;
        /// <summary>
        /// races_unfin
        /// </summary>
        public int racesUnfinished
        {
            get { return _racesunfinished; }
            set { _racesunfinished = value; }
        }

        protected int _lapssum = 0;
        /// <summary>
        /// laps_sum
        /// </summary>
        public int lapsSum
        {
            get { return _lapssum; }
            set { _lapssum = value; }
        }

        protected int _lapsfastest = 0;
        /// <summary>
        /// laps_fastest
        /// </summary>
        public int lapsFastest
        {
            get { return _lapsfastest; }
            set { _lapsfastest = value; }
        }

        protected int _pitlaneentersum = 0;
        /// <summary>
        /// pitlane_enter_sum
        /// </summary>
        public int pitlaneEnterSum
        {
            get { return _pitlaneentersum; }
            set { _pitlaneentersum = value; }
        }

        protected int _pitlanedtsum = 0;
        /// <summary>
        /// pitlane_dt_sum
        /// </summary>
        public int pitlaneDtSum
        {
            get { return _pitlanedtsum; }
            set { _pitlanedtsum = value; }
        }

        protected int _pitlanesgsum = 0;
        /// <summary>
        /// pitlane_sg_sum
        /// </summary>
        public int pitlaneSgSum
        {
            get { return _pitlanesgsum; }
            set { _pitlanesgsum = value; }
        }

        protected int _pitlanenopurposesum = 0;
        /// <summary>
        /// pitlane_nopurp_sum
        /// </summary>
        public int pitlaneNoPurposeSum
        {
            get { return _pitlanenopurposesum; }
            set { _pitlanenopurposesum = value; }
        }

        protected int _pitlanenumsum = 0;
        /// <summary>
        /// pitlane_num_sum
        /// </summary>
        public int pitlaneNumSum
        {
            get { return _pitlanenumsum; }
            set { _pitlanenumsum = value; }
        }

        protected int _pitstopssum = 0;
        /// <summary>
        /// pitstops_sum
        /// </summary>
        public int pitstopsSum
        {
            get { return _pitstopssum; }
            set { _pitstopssum = value; }
        }

        protected int _specsum = 0;
        /// <summary>
        /// spec_sum
        /// </summary>
        public int specSum
        {
            get { return _specsum; }
            set { _specsum = value; }
        }

        protected int _pensum = 0;
        /// <summary>
        /// pen_sum
        /// </summary>
        public int penSum
        {
            get { return _pitlanenumsum; }
            set { _pitlanenumsum = value; }
        }

        protected int _penfromblanksum = 0;
        /// <summary>
        /// pen_from0_sum
        /// </summary>
        public int penFromBlankSum
        {
            get { return _penfromblanksum; }
            set { _penfromblanksum = value; }
        }

        protected int _penfromadminsum = 0;
        /// <summary>
        /// pen_admin_sum
        /// </summary>
        public int penFromAdminSum
        {
            get { return _penfromadminsum; }
            set { _penfromadminsum = value; }
        }

        protected int _penfromadminfromblanksum = 0;
        /// <summary>
        /// pen_admin_from0_sum
        /// </summary>
        public int penFromAdminFromBlankSum
        {
            get { return _penfromadminfromblanksum; }
            set { _penfromadminfromblanksum = value; }
        }

        protected int _penfalsestartsum = 0;
        /// <summary>
        /// pen_fstart_sum
        /// </summary>
        public int penFalseStartSum
        {
            get { return _penfalsestartsum; }
            set { _penfalsestartsum = value; }
        }

        protected int _penfalsestartfromblanksum = 0;
        /// <summary>
        /// pen_fstart_from0_sum
        /// </summary>
        public int penFalseStartFromBlankSum
        {
            get { return _penfalsestartfromblanksum; }
            set { _penfalsestartfromblanksum = value; }
        }

        protected int _penspeedingsum = 0;
        /// <summary>
        /// pen_speeding_sum
        /// </summary>
        public int penSpeedingSum
        {
            get { return _penspeedingsum; }
            set { _penspeedingsum = value; }
        }

        protected int _penspeedingfromblanksum = 0;
        /// <summary>
        /// pen_speeding_from0_sum
        /// </summary>
        public int penSpeedingFromBlankSum
        {
            get { return _penspeedingfromblanksum; }
            set { _penspeedingfromblanksum = value; }
        }

        protected int _penpitstoptoolatesum = 0;
        /// <summary>
        /// pen_stoplate_sum
        /// </summary>
        public int penPitStopTooLateSum
        {
            get { return _penpitstoptoolatesum; }
            set { _penpitstoptoolatesum = value; }
        }

        protected int _penpitstoptoolatefromblanksum = 0;
        /// <summary>
        /// pen_stoplate_from0_sum
        /// </summary>
        public int penPitStopTooLateFromBlankSum
        {
            get { return _penpitstoptoolatefromblanksum; }
            set { _penpitstoptoolatefromblanksum = value; }
        }

        protected int _penpitstoptooshortsum = 0;
        /// <summary>
        /// pen_stopshort_sum
        /// </summary>
        public int penPitStopTooShortSum
        {
            get { return _penpitstoptooshortsum; }
            set { _penpitstoptooshortsum = value; }
        }

        protected int _penpitstoptooshortfromblanksum = 0;
        /// <summary>
        /// pen_stopshort_from0_sum
        /// </summary>
        public int penPitStopTooShortFromBlankSum
        {
            get { return _penpitstoptooshortfromblanksum; }
            set { _penpitstoptooshortfromblanksum = value; }
        }

        protected int _penwrongwaysum = 0;
        /// <summary>
        /// pen_wway_sum
        /// </summary>
        public int penWrongWaySum
        {
            get { return _penwrongwaysum; }
            set { _penwrongwaysum = value; }
        }

        protected int _penwrongwayfromblanksum = 0;
        /// <summary>
        /// pen_wway_from0_sum
        /// </summary>
        public int penWrongWayFromBlankSum
        {
            get { return _penwrongwayfromblanksum; }
            set { _penwrongwayfromblanksum = value; }
        }

        protected int _penunknownsum = 0;
        /// <summary>
        /// pen_unknown_sum
        /// </summary>
        public int penUnknownSum
        {
            get { return _penunknownsum; }
            set { _penunknownsum = value; }
        }

        protected int _pennumsum = 0;
        /// <summary>
        /// pen_num_sum
        /// </summary>
        public int penNumSum
        {
            get { return _pennumsum; }
            set { _pennumsum = value; }
        }

        protected int _flagblackssum = 0;
        /// <summary>
        /// blacks_sum
        /// </summary>
        public int flagBlacksSum
        {
            get { return _flagblackssum; }
            set { _flagblackssum = value; }
        }

        protected int _flagyellowssum = 0;
        /// <summary>
        /// yellows_sum
        /// </summary>
        public int flagYellowsSum
        {
            get { return _flagyellowssum; }
            set { _flagyellowssum = value; }
        }

        protected string _webkey = "_undetected";
        /// <summary>
        /// webkey
        /// </summary>
        public string webKey
        {
            get { return _webkey; }
            set { _webkey = value; }
        }

        protected string _firstseen = "_undetected";
        /// <summary>
        /// firstseen
        /// </summary>
        public string firstSeen
        {
            get { return _firstseen; }
            set { _firstseen = value; }
        }

        protected string _lastseen = "_undetected";
        /// <summary>
        /// lastseen
        /// </summary>
        public string lastSeen
        {
            get { return _lastseen; }
            set { _lastseen = value; }
        }
        #endregion

        protected string _settedreason = "";
        protected string _startpenalty = "";
        protected bool _startpenaltyapplynow = false;
        protected bool _firsttimeleavingpitlane = false;
        protected byte _uniqueid = 0;
        protected byte _playerid = 0;
		protected string _username = "_undetected";
		protected string _playername = "_undetected";
		protected byte _isadmin = 0;
		protected byte _flags = 0;
        protected string _action = "Nothing";

        protected int _numthreatsprev = 0;
        public int numThreatsPrev
        {
            get { return _numthreatsprev; }
            set { _numthreatsprev = value; }
        }

        protected bool _authorizedstart = true;
        public bool authorizedStart
        {
            get { return _authorizedstart; }
            set { _authorizedstart = value; }
        }

        protected bool _winneroflastrace = false;
        public bool winnerOfLastRace
        {
            get { return _winneroflastrace; }
            set { _winneroflastrace = value; }
        }

        protected int _currwinsinarow = 0;
        public int currWinsInARow
        {
            get { return _currwinsinarow; }
            set { _currwinsinarow = value; }
        }

        public string settedReason
        {
            get { return _settedreason; }
            set { _settedreason = value; }
        }

        public string startPenalty
        {
            get { return _startpenalty; }
            set { _startpenalty = value; }
        }

        public bool startPenaltyApplyNow
        {
            get { return _startpenaltyapplynow; }
            set { _startpenaltyapplynow = value; }
        }

        public bool firstTimeLeavingPitlane
        {
            get { return _firsttimeleavingpitlane; }
            set { _firsttimeleavingpitlane = value; }
        }

		/// <summary>Connection Unique ID</summary>
		public byte UniqueID
		{
			get { return _uniqueid; }
			set { _uniqueid = value; }
        }

        /// <summary>Connection Unique Player ID</summary>
        public byte PlayerID
        {
            get { return _playerid; }
            set { _playerid = value; }
        }

		/// <summary>Connection username</summary>
		public string Username
		{
			get { return _username; }
			set { _username = value; }
		}

		/// <summary>Connection player name</summary>
		public string PlayerName
		{
			get { return _playername; }
			set { _playername = value; }
		}

		/// <summary>Connection is admin</summary>
		public byte IsAdmin
		{
			get { return _isadmin; }
			set { _isadmin = value; }
		}

		/// <summary>Bit 2 : remote</summary>
		public byte Flags
		{
			get { return _flags; }
			set { _flags = value; }
        }

        /// <summary>Bit 2 : remote</summary>
        public string Action
        {
            get
            {
                try { return _action.ToLower(); }
                catch { return _action; };
            }
            set { _action = value; }
        }
	}
}